(function ($) {
    "use strict";

    // ------- Prealoder ------
    $(window).on('load', function () {
        $("#preloader").delay(300).fadeOut("slow");
    });


    // Handle Menu on Sreen scrolling
    function MenuOnScrol() {
        const elementToModify = document.querySelector(".site_header");
        let lastScrollTop = 0;
        window.addEventListener("scroll", () => {
            const scrollTop = window.scrollY || window.pageYOffset;
            if (scrollTop > lastScrollTop && lastScrollTop > 200) {
                elementToModify.classList.add("sticky");
            } else if (lastScrollTop < 210) {
                elementToModify.classList.remove("menu_up");
                elementToModify.classList.remove("sticky");
            } else {
                elementToModify.classList.remove("menu_up");
            }
            if (scrollTop > lastScrollTop) {
                elementToModify.classList.add("menu_up");
            }
            lastScrollTop = scrollTop;
        });
    }


    $(window).on('scroll', function () {
        if ($(this).scrollTop() > 600) {
            $('.back-to-top').addClass("topbtn_hide");
        } else {
            $('.back-to-top').removeClass("topbtn_hide");
        }
    });
    $('.back-to-top').on('click', function (event) {
        event.preventDefault();
        $('html, body').animate({
            scrollTop: 0,
        }, 1500);


        // Menu Hide
        MenuOnScrol()
    });


    $(document).ready(function () {

        // header scroling
        MenuOnScrol()


        // three_dots_toggle
        $('.three_dots_toggle').click(function (e) {
            $(".side_menu_modal").toggleClass('active');
            $(".three_dots_toggle").toggleClass("active");
            $('body').toggleClass("overflow-hidden");
        });
        
        $('.layer').click(function (e) {
            $(".side_menu_modal").toggleClass('active');
            $('body').toggleClass("overflow-hidden");
            $('.three_dots_toggle').toggleClass("active");
        });
        

        // Increase Decrease
        $(document).ready(function () {
            $(".increase").click(function () {
                var $outputElement = $(this).closest('.increment_decrement').find(".incre_decre_output");
                var currentValue = parseInt($outputElement.text());
                $outputElement.text(currentValue + 1);
            });

            $(".decrease").click(function () {
                var $outputElement = $(this).closest('.increment_decrement').find(".incre_decre_output");
                var currentValue = parseInt($outputElement.text());
                if (currentValue > 0) {
                    $outputElement.text(currentValue - 1);
                }
            });
        });

        // Select
        $('.select').click(function (e) {
            $('.select_wrap').not($(this).closest('.select_wrap')).removeClass('active');
            $(this).closest('.select_wrap').toggleClass("active");
        });

        $('.select_dropdown .select_text').click(function (e) {
            var select_text = $(this).html();

            $(this).closest('.select_wrap').find('.selected_text').html(select_text);

            $('.select_wrap').removeClass('active');
        });


        // nav-link chiptab_nav
        $('.nav-link.chiptab_nav').click(function (e) {
            var chiptab_btn_icon = $(this).find('.chiptab_btn_icon img').attr('src');
            var chiptab_btn_text = $(this).find('p').html()


            $('.chiptab_nav_sm p').html(chiptab_btn_text);
            $('.chiptab_nav_sm .chiptab_btn_icon img').attr('src', chiptab_btn_icon);
            $('.navtabs_sm').removeClass('show');
            $('.chiptab_nav_sm').addClass('collapsed');


            $('.navtabs_sm').height(0);

        });


        // ext_option_selected 
        $('.ext_option_selected').click(function (e) {
            $('.extrac_options_wrap').toggleClass('active');
        });
        $('.ext_option').click(function (e) {
            var getText = $(this).find('p').html();
            $('.ext_option_selected p').html(getText);
        });
        $('.extra_options_dropdown .ext_option').click(function (e) {
            $('.extrac_options_wrap').removeClass('active');
        });
        $('.radio').click(function (e) {
            $(this).toggleClass('active');
        });


        // input_field 
        $(document).ready(function () {
            $('.input_field').focus(function () {
                $(this).closest('.form_group').addClass('active');
            });

            $('.input_field').blur(function () {
                $(this).closest('.form_group').removeClass('active');
            });
        });

        // credit_input
        $(document).ready(function () {
            $('.credit_input').focus(function () {
                $(this).closest('.form_group').addClass('active');
            });

            $('.credit_input').blur(function () {
                $(this).closest('.form_group').removeClass('active');
            });
        });

        // selected_option 
        $('.selected_option').click(function (e) {
            $(this).closest('.select_input').toggleClass('active');
        });

        $('.select_option').click(function (e) {
            var gettext = $(this).html();

            $(this).closest('.select_input').find('.selected_option p').html(gettext);

            $('.select_input').removeClass('active');
        });


        // selected_calling_code
        $('.selected_calling_code').click(function (e) {
            $(this).closest('.calling_code_selector').toggleClass('active');
        });

        $('.calling_code_wrap .select_calling_code').click(function (e) {
            var gettext1 = $(this).find('.calling_code').html();
            var gettext2 = $(this).find('.Country_code').html();

            $(this).closest('.calling_code_selector').find('.selected_calling_code .calling_code').html(gettext1);
            $(this).closest('.calling_code_selector').find('.selected_calling_code .Country_code').html(gettext2);

            $('.calling_code_selector').removeClass('active');
        });



        // input_field
        $('.input_field').on('input', function () {
            if ($(this).val().length > 0) {
                $(this).closest('.form_group').addClass('highlight');
            } else {
                $(this).closest('.form_group').removeClass('highlight');
            }
        });


        // credit_input
        $('.credit_input').on('input', function () {
            if ($(this).val().length > 0) {
                $(this).closest('.form_group').addClass('highlight');
            } else {
                $(this).closest('.form_group').removeClass('highlight');
            }
        });


        // toure slider
        $(".owl-carousel.toolshop-slider").owlCarousel({
            loop: true,
            margin: 20,
            nav: true,
            dots: false,
            autoplay: true,
            items: 1,
            navText: [
                '<i class="fal fa-long-arrow-left"></i>',
                '<i class="fal fa-long-arrow-right"></i>',
            ],
        });


    });

})(jQuery);